//------------------------------------------------------------------------------
// File: cmn_resources.cs
// This file contains common resource methods for client and server
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Returns the SLResourceCap or SLResourceSlider object for the resource
//! specified
//! \param %rsrc Resource desired ($Resource::Gold, $Resource::Wood, etc.)
//! \retval int Id of SLResourceCap or SLResourceSlider object or 0
////////////////////////////////////////////////////////////////////////////////
function rsGetResource(%rsrc)
{
   // Default check
   if(!isObject(GameResourceStack)) {
      return 0;
   }
   if(%rsrc $= "") {
      return 0;
   }
   
   // Get resource
   %gamersrcs = GameResourceStack.getResource();
   if(!isObject(%gamersrcs)) {
      return 0;
   }
   
   switch(%rsrc) {
      case $Resource::Gold:
         return %gamersrcs.getGold();
      case $Resource::Wood:
         return %gamersrcs.getWood();
      case $Resource::Food:
         return %gamersrcs.getFood();
      case $Resource::Water:
         return %gamersrcs.getWater();
      case $Resource::People:
         return %gamersrcs.getPeople();
      case $Resource::Happiness:
         return %gamersrcs.getHappiness();
      case $Resource::Experience:
         return %gamersrcs.getExperience();
      default:
         return 0;
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Returns the current resource count for the resource specified
//! \param %rsrc Resource count desired ($Resource::Gold, $Resource::Wood, etc.)
//! \retval int Current count of resources (-1 is default if something fails)
////////////////////////////////////////////////////////////////////////////////
function rsGetResourceCount(%rsrc)
{
   // Return resource count
   %rsrcObj = rsGetResource(%rsrc);
   if(!isObject(%rsrcObj)) {
      return -1;
   }
   else {
      return %rsrcObj.getCount();
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Returns the current resource cap for the resource specified. If resource
//! does not have a cap, then max int is returned.
//! \param %rsrc Resource cap desired ($Resource::Gold, $Resource::Wood, etc.)
//! \retval int Current resource cap, max int, or -1 if an error occurred
////////////////////////////////////////////////////////////////////////////////
function rsGetResourceCap(%rsrc)
{
   // Return resource cap
   %rsrcObj = rsGetResource(%rsrc);
   if(!isObject(%rsrcObj)) {
      return  -1;
   }
   else {
      return %rsrcObj.getMax();
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Returns the path of the resource icon file if there is one
//! \param %rsrc Resource image file to obtain
//! \retval string Path name or 0
////////////////////////////////////////////////////////////////////////////////
function rsGetResourceIcon(%rsrc)
{
   switch(%rsrc) {
      case $Resource::Gold:
         return $GoldIconPath;
      case $Resource::Wood:
         return $WoodIconPath;
      case $Resource::Food:
         return $FoodIconPath;
      case $Resource::Water:
         return $WaterIconPath;
      default:
         return 0;
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Returns the production affect of happiness when high or low
//! \retval Above one if high, below one if low, and one if no effect
////////////////////////////////////////////////////////////////////////////////
function rsGetHappinessProductionAffect()
{
   %happyCnt = rsGetResourceCount($Resource::Happiness);
   
   // Happiness rates
   %happyLow  = GameResourceData.happinessLowRate;
   %happyHigh = GameResourceData.happinessHighRate;
   
   // Happiness lowers production
   if(%happyCnt <= getWord(%happyLow, 0)) {
      return getWord(%happyLow, 1);
   }
   // Happiness raises production
   else if(%happyCnt >= getWord(%happyHigh, 0)) {
      return getWord(%happyHigh, 1);
   }
   // Happiness does not affect production
   else {
      return 1;
   }
}

// End cmn_resources.cs